import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/form_section/send_currency_dropdawon.dart';

import '../../../../../../core/utils/my_color.dart';
import '../../../../../../data/controller/home/home_controller.dart';
import '../../../../../components/text-form-field/custom_amount_text_field.dart';

// ignore: must_be_immutable
class SendCurrencyField extends StatelessWidget {
  final bool enableOptionalItem;

  const SendCurrencyField({super.key, this.enableOptionalItem = false});

  @override
  Widget build(BuildContext context) {
    double width = MediaQuery.of(context).size.width;
    print("this is status ${enableOptionalItem}");

    return GetBuilder<HomeController>(builder: (controller) {
       print("this is test ${controller.balance}");
      return Container(
        width: width,
        decoration: BoxDecoration(
          border: Border.all(color: MyColor.customBorderColor, width: .5),
          borderRadius: BorderRadius.circular(4),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Expanded(
                child: SendCurrencyDropDown(
              isBorder: false,
              enableOptionalItem: enableOptionalItem,
            )),
            SizedBox(
              child: Container(
                color: const Color(0xFFD0D0D0),
                height: 20,
                width: 0.5,
              ),
            ),
            Expanded(
              child: CustomAmountTextField(
                labelText: '',
                hintText: '0.0',
                currency: controller.selectedSendCountry.currency ?? controller.homeRepo.apiClient.getCurrencyOrUsername(isCurrency: true),
                onChanged: (value) {
                  controller.sendCurrencyExchangeRateCalculate(value);
                },
                needLabelText: false,
                readOnly: controller.selectedSendCountry.id == -1 ? true : false,
                controller: controller.sendingAmountController,
              ),
            )
          ],
        ),
      );
    });
  }
}
